"""
This shows a simple example of using the NumericModelExplorer, which in turn
is built using the:
    
    - NumericEditor
    - TableEditor
    - SetEditor
    - CustomEditor (for the Chaco plots)
"""    

# Imports:
from enthought.util.numerix \
    import arange, sin, cos 

from enthought.model.numeric_model_explorer \
    import NumericArrayModel, NumericModelExplorer

# Create a sample index range:
x = arange( -20.0, 20.005, 0.1 )

# Define a NumericModel from a series of arrays:
model = NumericArrayModel( x     = x, 
                           sinx  = sin( x ), 
                           cosx  = cos( x ),
                           xsinx = x * sin( x ),
                           xcosx = x * cos( x ) )

# Create the NumericModelExplorer from the model:
popup = NumericModelExplorer( model = model )

if __name__ == '__main__':
    popup.configure_traits()
